/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "twitchsdk/core/internal/pch.h"

#include "twitchsdk/core/memory.h"

namespace ttv {
// NOTE: The implementation of these functions are defined in platform-specific *memory.cpp

void* DefaultAlignedMalloc(size_t size, size_t alignment);
void DefaultAlignedFree(void* p);

extern TTV_AllocCallback gAllocCallback;
extern TTV_FreeCallback gFreeCallback;

TTV_AllocCallback gAllocCallback = DefaultAlignedMalloc;
TTV_FreeCallback gFreeCallback = DefaultAlignedFree;
}  // namespace ttv

void* ttv::AlignedAlloc(size_t size, size_t alignment) {
  return gAllocCallback(size, alignment);
}

void ttv::AlignedFree(void* p) {
  TTV_ASSERT(gFreeCallback != nullptr);

  gFreeCallback(p);
}

TTV_ErrorCode ttv::SetMemoryAllocationCallbacks(TTV_AllocCallback allocCallback, TTV_FreeCallback freeCallback) {
  gAllocCallback = allocCallback;
  gFreeCallback = freeCallback;

  return TTV_EC_SUCCESS;
}
