/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "twitchsdk/core/internal/pch.h"

#include "twitchsdk/core/mutex.h"

#include "twitchsdk/core/resourcefactorychain.h"

#ifdef CreateMutex
#undef CreateMutex
#endif

namespace {
using namespace ttv;

std::shared_ptr<IMutexFactory> gMutexFactory;
}  // namespace

void ttv::SetMutexFactory(std::shared_ptr<IMutexFactory> factory) {
  gMutexFactory = factory;
}

TTV_ErrorCode ttv::CreateMutex(std::unique_ptr<ttv::IMutex>& result, const std::string& name) {
  TTV_ASSERT(gMutexFactory != nullptr);
  if (gMutexFactory == nullptr) {
    return TTV_EC_NOT_INITIALIZED;
  }

  return gMutexFactory->CreateMutex(result, name);
}

TTV_ErrorCode ttv::CreateConditionMutex(std::unique_ptr<ttv::IConditionMutex>& result, const std::string& name) {
  TTV_ASSERT(gMutexFactory != nullptr);
  if (gMutexFactory == nullptr) {
    return TTV_EC_NOT_INITIALIZED;
  }

  return gMutexFactory->CreateConditionMutex(result, name);
}

AutoMutex::AutoMutex(IMutex* mutex) : mMutex(mutex) {
  TTV_ASSERT(mutex != nullptr);
  TTV_ErrorCode ec = mMutex->Lock();
  TTV_ASSERT(ec == TTV_EC_SUCCESS);
}

AutoMutex::~AutoMutex() {
  TTV_ErrorCode ec = mMutex->Unlock();
  TTV_ASSERT(ec == TTV_EC_SUCCESS);
}
