/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "twitchsdk/core/internal/pch.h"

#include "twitchsdk/core/pubsub/pubsubclientmessages.h"

#include "twitchsdk/core/pubsub/pubsubclient.h"

ttv::pubsub::SendMessageResultClientMessage::SendMessageResultClientMessage(
  TTV_ErrorCode errorCode, PubSubClient::SendMessageCallback callbackArg) {
  type = ClientMessageType::SendMessageResult;

  ec = errorCode;
  callback = callbackArg;
}

ttv::pubsub::StateChangedClientMessage::StateChangedClientMessage(PubSubState stateArg, TTV_ErrorCode errorCode) {
  type = ClientMessageType::StateChanged;

  ec = errorCode;
  state = stateArg;
}

ttv::pubsub::MessageReceivedClientMessage::MessageReceivedClientMessage(
  const std::string& topicArg, const json::Value& dataArg) {
  type = ClientMessageType::MessageReceived;

  topic = topicArg;
  data = dataArg;
}

ttv::pubsub::TopicSubscriptionChangedClientMessage::TopicSubscriptionChangedClientMessage(
  const std::string& topicArg, PubSubClient::SubscribeState::Enum stateArg, TTV_ErrorCode errorCode) {
  type = ClientMessageType::TopicSubscriptionChanged;

  ec = errorCode;
  topic = topicArg;
  state = stateArg;
}

ttv::pubsub::TopicListenerRemovedClientMessage::TopicListenerRemovedClientMessage(
  std::shared_ptr<PubSubClient::ITopicListener> listenerArg, const std::string& topicArg, TTV_ErrorCode errorCode) {
  type = ClientMessageType::TopicListenerRemoved;

  ec = errorCode;
  topic = topicArg;
  listener = listenerArg;
}

ttv::pubsub::AuthErrorReceivedClientMessage::AuthErrorReceivedClientMessage(
  TTV_ErrorCode errorCode, const std::shared_ptr<const OAuthToken>& authTokenArg) {
  type = ClientMessageType::AuthErrorReceived;

  ec = errorCode;
  authToken = authTokenArg;
}

ttv::pubsub::ShutdownCompleteClientMessage::ShutdownCompleteClientMessage() {
  type = ClientMessageType::ShutdownComplete;
}

ttv::pubsub::ConnectionPreferenceServerMessage::ConnectionPreferenceServerMessage(
  PubSubClient::ConnectionPreference::Enum preferenceArg) {
  type = ServerMessageType::ConnectionPreference;

  preference = preferenceArg;
}

ttv::pubsub::ConnectServerMessage::ConnectServerMessage() {
  type = ServerMessageType::Connect;
}

ttv::pubsub::DisconnectServerMessage::DisconnectServerMessage() {
  type = ServerMessageType::Disconnect;
}

ttv::pubsub::SendMessageServerMessage::SendMessageServerMessage(
  const json::Value& dataArg, PubSubClient::SendMessageCallback callbackArg) {
  type = ServerMessageType::SendMessage;

  data = dataArg;
  callback = callbackArg;
}

ttv::pubsub::SubscribeToTopicServerMessage::SubscribeToTopicServerMessage(const std::string& topicArg,
  std::shared_ptr<const OAuthToken> oauthArg, std::shared_ptr<PubSubClient::ITopicListener> listenerArg) {
  type = ServerMessageType::SubscribeToTopic;

  topic = topicArg;
  oauth = oauthArg;
  listener = listenerArg;
}

ttv::pubsub::UnsubscribeFromTopicServerMessage::UnsubscribeFromTopicServerMessage(
  const std::string& topicArg, std::shared_ptr<PubSubClient::ITopicListener> listenerArg) {
  type = ServerMessageType::UnsubscribeFromTopic;

  topic = topicArg;
  listener = listenerArg;
}

ttv::pubsub::ShutdownServerMessage::ShutdownServerMessage() {
  type = ServerMessageType::Shutdown;
}
