/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/
#include "twitchsdk/core/internal/pch.h"

#include "twitchsdk/core/settingrepository.h"

#include "twitchsdk/core/mutex.h"
#include "twitchsdk/core/tracer.h"

namespace {
const char* kLogger = "SettingRepository";
}

ttv::SettingRepository::SettingRepository() {
  TTV_ErrorCode ec = ttv::CreateMutex(mMutex, "SettingRepository");
  TTV_ASSERT(TTV_SUCCEEDED(ec) && mMutex != nullptr);
}

void ttv::SettingRepository::SetSetting(const std::string& key, const std::string& value) {
  AutoMutex lock(mMutex.get());

  mSettings[key] = value;

  ttv::trace::Message(
    kLogger, MessageLevel::Info, "SettingRepository::AddSetting: '%s' ==> '%s'", key.c_str(), value.c_str());
}

bool ttv::SettingRepository::GetSetting(const std::string& key, std::string& value) {
  AutoMutex lock(mMutex.get());

  auto iter = mSettings.find(key);
  if (iter != mSettings.end()) {
    value = iter->second;
    return true;
  } else {
    return false;
  }
}

bool ttv::SettingRepository::RemoveSetting(const std::string& key) {
  AutoMutex lock(mMutex.get());

  auto iter = mSettings.find(key);
  if (iter != mSettings.end()) {
    ttv::trace::Message(kLogger, MessageLevel::Info, "SettingRepository::RemoveSetting: '%s'", key.c_str());

    return true;
  } else {
    ttv::trace::Message(
      kLogger, MessageLevel::Info, "SettingRepository::RemoveSetting: Setting doesn't exist: '%s'", key.c_str());

    return false;
  }
}
