/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "twitchsdk/core/internal/pch.h"

#include "twitchsdk/core/task/lambdatask.h"

ttv::LambdaTask::LambdaTask(JobCallback lambda, CompleteCallback callback)
    : mName("LambdaTask"), mLambda(lambda), mCallback(callback), mTaskStatus(TTV_EC_SUCCESS) {
  ttv::trace::Message(GetTaskName(), MessageLevel::Info, "LambdaTask created");
}

ttv::LambdaTask::LambdaTask(const std::string& name, JobCallback lambda, CompleteCallback callback)
    : mName(std::string("LambdaTask[") + name + "]"),
      mLambda(lambda),
      mCallback(callback),
      mTaskStatus(TTV_EC_SUCCESS) {
  ttv::trace::Message(GetTaskName(), MessageLevel::Info, "LambdaTask [%s] created", mName.c_str());
}

void ttv::LambdaTask::Run() {
  if (mLambda != nullptr) {
    mTaskStatus = mLambda();
  }
}

void ttv::LambdaTask::OnComplete() {
  if (mCallback) {
    if (mAborted) {
      mTaskStatus = TTV_EC_REQUEST_ABORTED;
    }

    mCallback(this, mTaskStatus);
  }
}
