/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "twitchsdk/core/internal/pch.h"

#include "twitchsdk/core/task/uploadprofileimagetask.h"

#include "twitchsdk/core/httprequestutils.h"
#include "twitchsdk/core/json/corejsonutil.h"
#include "twitchsdk/core/json/reader.h"

#include <sstream>

ttv::UploadProfileImageTask::UploadProfileImageTask(
  const std::string& uploadUrl, const std::string& image, Callback callback)
    : HttpTask(nullptr, nullptr, nullptr),
      mCallback(callback),
      mUploadUrl(uploadUrl),
      mImage(image)

{
  ttv::trace::Message(GetTaskName(), MessageLevel::Info, "UploadProfileImageTask created");
}

void ttv::UploadProfileImageTask::FillHttpRequestInfo(HttpRequestInfo& requestInfo) {
  requestInfo.url = mUploadUrl;
  requestInfo.httpReqType = HTTP_PUT_REQUEST;
  requestInfo.requestBody = mImage;
}

void ttv::UploadProfileImageTask::ProcessResponse(uint /*statusCode*/, const std::vector<char>& /*response*/) {
  // Nothing to check here, as the response from the API will be empty.
}

void ttv::UploadProfileImageTask::OnComplete() {
  if (mCallback) {
    if (mAborted) {
      mTaskStatus = TTV_EC_REQUEST_ABORTED;
    }

    mCallback(this, mTaskStatus.ec, mResult);
  }
}
