/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "twitchsdk/core/internal/pch.h"

#include "twitchsdk/core/thread.h"

#include "twitchsdk/core/mutex.h"
#include "twitchsdk/core/resourcefactorychain.h"

namespace {
using namespace ttv;

std::shared_ptr<IThreadFactory> gThreadFactory;
std::shared_ptr<IThreadApi> gThreadApi;
}  // namespace

void ttv::Sleep(uint64_t milliseconds) {
  TTV_ASSERT(gThreadApi != nullptr);
  if (gThreadApi == nullptr) {
    ttv::trace::Message("Thread", MessageLevel::Error, "%s", "InitializeThreadLibrary() not called");
    return;
  }

  gThreadApi->Sleep(milliseconds);
}

ttv::IThreadFactory::~IThreadFactory() {}

ttv::IThread::~IThread() {}

ttv::IThreadApi::~IThreadApi() {}

TTV_ErrorCode ttv::SetThreadFactory(std::shared_ptr<IThreadFactory> factory) {
  gThreadFactory = factory;

  return TTV_EC_SUCCESS;
}

TTV_ErrorCode ttv::SetThreadApi(std::shared_ptr<IThreadApi> api) {
  gThreadApi = api;

  return TTV_EC_SUCCESS;
}

TTV_ErrorCode ttv::CreateThread(ThreadProc threadProc, const std::string& name, std::shared_ptr<IThread>& result) {
  TTV_ASSERT(gThreadFactory != nullptr);
  if (gThreadFactory == nullptr) {
    return TTV_EC_NOT_INITIALIZED;
  }

  return gThreadFactory->CreateThread(threadProc, name, result);
}
