/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "twitchsdk/core/internal/pch.h"

#include "twitchsdk/core/threadedeventschedulerfactory.h"

#include "twitchsdk/core/threadedeventscheduler.h"

TTV_ErrorCode ttv::ThreadedEventSchedulerFactory::CreateBackgroundEventScheduler(
  std::shared_ptr<IEventScheduler>& result) {
  result = std::make_shared<ThreadedEventScheduler>();

  return TTV_EC_SUCCESS;
}

TTV_ErrorCode ttv::ThreadedEventSchedulerFactory::CreateBackgroundEventScheduler(
  const std::string& name, std::shared_ptr<IEventScheduler>& result) {
  result = std::make_shared<ThreadedEventScheduler>(name);

  return TTV_EC_SUCCESS;
}
