/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "twitchsdk/core/internal/pch.h"

#include "twitchsdk/core/threadsync.h"

namespace {
using namespace ttv;

std::shared_ptr<IThreadSyncFactory> gThreadSyncFactory;
}  // namespace

ttv::IThreadSync::~IThreadSync() {}

ttv::IThreadSyncFactory::~IThreadSyncFactory() {}

void ttv::SetThreadSyncFactory(std::shared_ptr<IThreadSyncFactory> factory) {
  gThreadSyncFactory = factory;
}

TTV_ErrorCode ttv::CreateThreadSync(std::shared_ptr<IThreadSync>& result, const std::string& name) {
  TTV_ASSERT(gThreadSyncFactory != nullptr);
  if (gThreadSyncFactory == nullptr) {
    return TTV_EC_NOT_INITIALIZED;
  }

  return gThreadSyncFactory->CreateThreadSync(result, name);
}
