/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/core/socket.h"

#include <type_traits>

#include <map>

namespace ttv {
namespace test {
class TestWebSocketFactory;
}
}  // namespace ttv

class ttv::test::TestWebSocketFactory : public ttv::IWebSocketFactory {
 public:
  void SetSocket(std::shared_ptr<ttv::IWebSocket> socket, const std::string& uri);

  // IWebSocketFactory implementation
  virtual TTV_ErrorCode CreateWebSocket(const std::string& uri, std::shared_ptr<IWebSocket>& result) override;
  virtual bool IsProtocolSupported(const std::string& protocol) override;

 private:
  std::map<std::string, std::shared_ptr<ttv::IWebSocket>> mSocketMap;
};
