/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "testhttprequest.h"
#include "twitchsdk/core/json/value.h"
#include "twitchsdk/core/user/userrepository.h"

namespace ttv {
namespace test {
class UserTestUtility;
}
}  // namespace ttv

class ttv::test::UserTestUtility {
 public:
  void SetUpStubs(std::shared_ptr<TestHttpRequest> testHttpRequest);

  UserInfo DefaultUserInfo() const;

  void RegisterUserInfo(const std::string& authToken, const UserInfo& userInfo);

  static json::Value JsonForUserInfoKraken(const UserInfo& userinfo);
  static json::Value JsonForUserInfo(const UserInfo& userinfo);

 private:
  std::map<std::string, UserInfo> mUserInfosByAuthToken;
};
