/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "fixtures/sdkbasetest.h"
#include "testutilities.h"
#include "twitchsdk/core/json/reader.h"

using namespace ttv;
using namespace ttv::test;

TEST(JsonReader, IntegerParsing) {
  int64_t minInt = std::numeric_limits<int64_t>::lowest();
  int64_t maxInt = std::numeric_limits<int64_t>::max();
  uint64_t maxUInt = std::numeric_limits<uint64_t>::max() /
                     10;  // Divide by 10, otherwise json reader parses it as a double to prevent overflow
  uint64_t maxUIntAsReal = std::numeric_limits<uint64_t>::max();
  double negativeDouble = -92233720368547758080.0;

  std::string body =
    "{"
    "\"minInt\":" +
    std::to_string(minInt) +
    ","
    "\"maxInt\":" +
    std::to_string(maxInt) +
    ","
    "\"maxUInt\":" +
    std::to_string(maxUInt) +
    ","
    "\"maxUIntAsReal\":" +
    std::to_string(maxUIntAsReal) +
    ","
    "\"negativeDouble\": -92233720368547758080" +
    "}";

  json::Reader reader;
  json::Value root;

  EXPECT_TRUE(reader.parse(body, root));
  EXPECT_EQ(minInt, root["minInt"].asInt());
  EXPECT_EQ(maxInt, root["maxInt"].asInt());
  EXPECT_EQ(maxUInt, root["maxUInt"].asUInt());
  EXPECT_DOUBLE_EQ(static_cast<double>(maxUIntAsReal), root["maxUIntAsReal"].asDouble());
  EXPECT_DOUBLE_EQ(negativeDouble, root["negativeDouble"].asDouble());
}
