/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "twitchsdk/core/sha1.h"

#include <memory>

#include "gtest/gtest.h"

namespace {
class Sha1Test : public ::testing::Test {};
}  // namespace

TEST(Sha1Test, TestHello) {
  /*
    import hashlib
    m = hashlib.sha1()
    m.update("Hello")
    m.hexdigest()
    */

  ttv::SHA1 sha1;
  sha1.Update("Hello");
  ASSERT_EQ(sha1.Final(), "f7ff9e8b7bb2e09b70935a5d785e0cc5d9d0abf0");
}

TEST(Sha1Test, TestEmptyString) {
  /*
    import hashlib
    m = hashlib.sha1()
    m.update("")
    m.hexdigest()
    */

  ttv::SHA1 sha1;
  sha1.Update("");
  ASSERT_EQ(sha1.Final(), "da39a3ee5e6b4b0d3255bfef95601890afd80709");
}

TEST(Sha1Test, TestNoUpdate) {
  /*
    import hashlib
    m = hashlib.sha1()
    m.hexdigest()
    */

  ttv::SHA1 sha1;
  ASSERT_EQ(sha1.Final(), "da39a3ee5e6b4b0d3255bfef95601890afd80709");
}

TEST(Sha1Test, TestMultipleUpdate) {
  /*
    import hashlib
    a = hashlib.sha1()
    a.update("123456789")
    a.hexdigest()
    b = hashlib.sha1()
    b.update("1")
    b.update("2")
    b.update("3")
    b.update("4")
    b.update("5")
    b.update("6")
    b.update("7")
    b.update("8")
    b.update("9")
    b.hexdigest()
    */

  ttv::SHA1 a;
  a.Update("123456789");
  ASSERT_EQ(a.Final(), "f7c3bc1d808e04732adf679965ccc34ca7ae3441");

  ttv::SHA1 b;
  b.Update("1");
  b.Update("2");
  b.Update("3");
  b.Update("4");
  b.Update("5");
  b.Update("6");
  b.Update("7");
  b.Update("8");
  b.Update("9");
  ASSERT_EQ(b.Final(), "f7c3bc1d808e04732adf679965ccc34ca7ae3441");
}
