/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "fixtures/sdkbasetest.h"
#include "twitchsdk/core/httprequestutils.h"

#include "gtest/gtest.h"

using namespace ttv::test;

TEST_F(SdkBaseTest, GenerateSslVerificationHosts) {
  std::vector<std::string> hostNames;

  std::string host = "twitch.tv";
  ttv::GenerateSslVerificationHosts(host, hostNames);
  ASSERT_EQ(hostNames.size(), 1);
  ASSERT_EQ(hostNames[0], "twitch.tv");
  hostNames.clear();

  host = "pubsub-edge.twitch.tv";
  ttv::GenerateSslVerificationHosts(host, hostNames);
  ASSERT_EQ(hostNames.size(), 3);
  ASSERT_EQ(hostNames[0], "pubsub-edge.twitch.tv");
  ASSERT_EQ(hostNames[1], "*.twitch.tv");
  ASSERT_EQ(hostNames[2], "twitch.tv");
  hostNames.clear();

  host = "irc-ws.chat.twitch.tv";
  ttv::GenerateSslVerificationHosts(host, hostNames);
  ASSERT_EQ(hostNames.size(), 5);
  ASSERT_EQ(hostNames[0], "irc-ws.chat.twitch.tv");
  ASSERT_EQ(hostNames[1], "*.chat.twitch.tv");
  ASSERT_EQ(hostNames[2], "chat.twitch.tv");
  ASSERT_EQ(hostNames[3], "*.twitch.tv");
  ASSERT_EQ(hostNames[4], "twitch.tv");
  hostNames.clear();

  host = "something.sony.com";
  ttv::GenerateSslVerificationHosts(host, hostNames);
  ASSERT_EQ(hostNames.size(), 3);
  ASSERT_EQ(hostNames[0], "something.sony.com");
  ASSERT_EQ(hostNames[1], "*.sony.com");
  ASSERT_EQ(hostNames[2], "sony.com");
  hostNames.clear();
}

TEST_F(SdkBaseTest, IpAddressHosts) {
  ASSERT_TRUE(ttv::IsHostAnIpAddress("1.2.3.4"));
  ASSERT_TRUE(ttv::IsHostAnIpAddress("0.0.0.0"));
  ASSERT_TRUE(ttv::IsHostAnIpAddress("255.21.1.0"));
  ASSERT_TRUE(ttv::IsHostAnIpAddress("23.243.28.28"));
  ASSERT_TRUE(ttv::IsHostAnIpAddress("2.23.255.0"));

  ASSERT_FALSE(ttv::IsHostAnIpAddress("twitch.tv"));
  ASSERT_FALSE(ttv::IsHostAnIpAddress("1.2.345"));
  ASSERT_FALSE(ttv::IsHostAnIpAddress("1.2.255"));
  ASSERT_FALSE(ttv::IsHostAnIpAddress("1.2.255."));
  ASSERT_FALSE(ttv::IsHostAnIpAddress("1.2.3.4."));
  ASSERT_FALSE(ttv::IsHostAnIpAddress("1.2.3.4.5"));
  ASSERT_FALSE(ttv::IsHostAnIpAddress("1...45"));
  ASSERT_FALSE(ttv::IsHostAnIpAddress(".1.3.45"));
  ASSERT_FALSE(ttv::IsHostAnIpAddress("..3.45"));
  ASSERT_FALSE(ttv::IsHostAnIpAddress("2..3.45"));
  ASSERT_FALSE(ttv::IsHostAnIpAddress("3.-3.25.32"));
  ASSERT_FALSE(ttv::IsHostAnIpAddress("1.2.3.4twitch"));
  ASSERT_FALSE(ttv::IsHostAnIpAddress("a.b.c.d"));
}
