#include "twitchsdk/core/internal/pch.h"

#include "fixtures/tasktest.h"
#include "testutilities.h"
#include "twitchsdk/core/task/getstreamtask.h"

#include <gtest/gtest.h>

namespace ttv {
namespace test {

class GetStreamTaskTests : public TaskTest {};

TEST_F(GetStreamTaskTests, PayloadToStreamInfoConversion) {
  constexpr auto payload = R"(
{
  "data": {
    "user": {
      "stream": {
        "previewImageURL": "user-stream-previewImageURL",
        "game": {
          "name": "user-stream-game-name"
        },
        "averageFPS": 1,
        "id": "2",
        "delayLengthSeconds": 3,
        "viewersCount": 4,
        "height": 5,
        "createdAt": "0000-00-00T00:00:00.000000Z",
        "broadcasterSoftware": "user-stream-broadcasterSoftware",
        "type": "user-stream-type",
        "archiveVideo": {
          "id": "6"
        }
      },
      "displayName": "user-displayName",
      "login": "user-login",
      "lastBroadcast": {
        "game": {
          "name": "user-lastBroadcast-game-name"
        },
        "title": "user-lastBroadcast-title"
      },
      "description": "user-description",
      "broadcastSettings": {
        "language": "en",
        "isMature": true
      },
      "profileImageURL": "user-profileImageURL",
      "profileURL": "user-profileURL",
      "offlineImageURL": null,
      "bannerImageURL": null,
      "id": "6",
      "createdAt": "-",
      "updatedAt": "-",
      "followers": {
        "totalCount": 7
      },
      "profileViewCount": 8,
      "roles": {
        "isAffiliate": false,
        "isPartner": false
      }
    }
  }
}
)";
  auto response = mHttpRequest->AddResponse("https://gql.twitch.tv/gql")
                    .SetType(HTTP_POST_REQUEST)
                    .AddRequestRegex(std::regex("GetStream"))
                    .SetResponseBody(payload)
                    .Done();

  auto result = RunTaskWithResult<GetStreamTask>(0, "");

  ASSERT_NE(result, nullptr);
  ASSERT_NE(result->streamInfo, nullptr);

  auto streamInfo = *result->streamInfo;

  EXPECT_EQ(streamInfo.game, "user-stream-game-name");
  EXPECT_EQ(streamInfo.averageFPS, 1);
  EXPECT_EQ(streamInfo.streamId, 2);
  EXPECT_EQ(streamInfo.delay, 3);
  EXPECT_EQ(streamInfo.viewerCount, 4);
  EXPECT_EQ(streamInfo.videoHeight, 5);
  EXPECT_EQ(streamInfo.archiveVideoId, 6);
}

TEST_F(GetStreamTaskTests, LargeStreamId_GT_32_Bits) {
  constexpr auto payload = R"(
{
  "data": {
    "user": {
      "stream": {
        "previewImageURL": "user-stream-previewImageURL",
        "game": {
          "name": "user-stream-game-name"
        },
        "averageFPS": 1,
        "id": "281474976710655",
        "delayLengthSeconds": 3,
        "viewersCount": 4,
        "height": 5,
        "createdAt": "0000-00-00T00:00:00.000000Z",
        "broadcasterSoftware": "user-stream-broadcasterSoftware",
        "type": "user-stream-type",
        "archiveVideo": {
          "id": "281474976710655"
        }
      },
      "displayName": "user-displayName",
      "login": "user-login",
      "lastBroadcast": {
        "game": {
          "name": "user-lastBroadcast-game-name"
        },
        "title": "user-lastBroadcast-title"
      },
      "description": "user-description",
      "broadcastSettings": {
        "language": "en",
        "isMature": true
      },
      "profileImageURL": "user-profileImageURL",
      "profileURL": "user-profileURL",
      "offlineImageURL": null,
      "bannerImageURL": null,
      "id": "6",
      "createdAt": "-",
      "updatedAt": "-",
      "followers": {
        "totalCount": 7
      },
      "profileViewCount": 8,
      "roles": {
        "isAffiliate": false,
        "isPartner": false
      }
    }
  }
}
)";
  auto response = mHttpRequest->AddResponse("https://gql.twitch.tv/gql")
                    .SetType(HTTP_POST_REQUEST)
                    .AddRequestRegex(std::regex("GetStream"))
                    .SetResponseBody(payload)
                    .Done();

  auto result = RunTaskWithResult<GetStreamTask>(0, "");

  ASSERT_NE(result, nullptr);
  ASSERT_NE(result->streamInfo, nullptr);

  auto streamInfo = *result->streamInfo;

  EXPECT_EQ(streamInfo.streamId, 281474976710655);
  EXPECT_EQ(streamInfo.archiveVideoId, 281474976710655);
}

}  // namespace test
}  // namespace ttv
