/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "testwebsocketfactory.h"

void ttv::test::TestWebSocketFactory::SetSocket(std::shared_ptr<ttv::IWebSocket> socket, const std::string& uri) {
  mSocketMap[uri] = socket;
}

TTV_ErrorCode ttv::test::TestWebSocketFactory::CreateWebSocket(
  const std::string& uri, std::shared_ptr<IWebSocket>& result) {
  result = mSocketMap[uri];
  return (result == nullptr) ? TTV_EC_UNIMPLEMENTED : TTV_EC_SUCCESS;
}

bool ttv::test::TestWebSocketFactory::IsProtocolSupported(const std::string& protocol) {
  return protocol == "ws" || protocol == "wss";
}
