/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "fixtures/sdkbasetest.h"
#include "twitchsdk/core/httprequestutils.h"

#include "gtest/gtest.h"

using namespace ttv::test;

TEST_F(SdkBaseTest, UrlEncode) {
  std::stringstream stringstream;
  ttv::UrlEncode("alphanumericstring1234", stringstream);
  ASSERT_EQ(stringstream.str(), "alphanumericstring1234");

  stringstream.str("");
  stringstream.clear();

  ttv::UrlEncode("string_with-valid~unencodable.characters", stringstream);
  ASSERT_EQ(stringstream.str(), "string_with-valid~unencodable.characters");

  stringstream.str("");
  stringstream.clear();

  ttv::UrlEncode("string with spaces & special characters: / +", stringstream);
  ASSERT_EQ(stringstream.str(), "string%20with%20spaces%20%26%20special%20characters%3A%20%2F%20%2B");
}

TEST_F(SdkBaseTest, PokemonUrlEncode) {
  std::stringstream ss;
  ttv::UrlEncode("Pok\xc3\xa9mon: Let's Go, Pikachu!/Eevee!", ss);
  ASSERT_EQ(ss.str(), "Pok%C3%A9mon%3A%20Let%27s%20Go%2C%20Pikachu%21%2FEevee%21");
}

TEST_F(SdkBaseTest, UrlDecode) {
  std::stringstream stringstream;
  ttv::UrlDecode("alphanumericstring1234", stringstream);
  ASSERT_EQ(stringstream.str(), "alphanumericstring1234");

  stringstream.str("");
  stringstream.clear();

  ttv::UrlDecode("string_with-valid~unencodable.characters", stringstream);
  ASSERT_EQ(stringstream.str(), "string_with-valid~unencodable.characters");

  stringstream.str("");
  stringstream.clear();

  ttv::UrlDecode("string%20with%20spaces%20%26%20special%20characters%3A%20%2F%20%2B", stringstream);
  ASSERT_EQ(stringstream.str(), "string with spaces & special characters: / +");
}
