##########################################################################################################
#
# Fragment: core_darwin
#
# See README.md for fragment documentation.
#
##########################################################################################################

import glob
import os
import build_types

def load_twitchsdk_fragment(primitives, options):

    fragment = build_types.SourceFragment('twitchsdk', 'core_darwin', os.path.dirname(os.path.realpath(__file__)))

    # Preprocessor defines
    #  <None>

    # Pull in primitives
    use_all_implementations = options.has_setting('TTV_USEALL_DARWIN_IMPLEMENTATIONS')

    if use_all_implementations or options.has_setting('TTV_USE_DARWIN_CFHTTPREQUEST'):
        fragment.add_source_files( os.path.join(fragment.root_path, "source/cfhttprequest.cpp") )
        fragment.add_header_files( os.path.join(fragment.root_path, "include/twitchsdk/core/cfhttprequest.h") )

        if not primitives.implemented('HTTP_REQUEST'):
            primitives.set('HTTP_REQUEST', "ttv::CfHttpRequest", "twitchsdk/core/cfhttprequest.h")

    if use_all_implementations or options.has_setting('TTV_USE_DARWIN_RAW_CFSOCKET'):
        fragment.add_source_files( os.path.join(fragment.root_path, "source/cfsocket.cpp") )
        fragment.add_header_files( os.path.join(fragment.root_path, "include/twitchsdk/core/cfsocket.h") )

        if not primitives.implemented('RAW_SOCKET_FACTORY'):
            primitives.set('RAW_SOCKET_FACTORY', "ttv::RawCFSocketFactory", "twitchsdk/core/cfsocket.h")

    if use_all_implementations or options.has_setting('TTV_USE_DARWIN_TLS_CFSOCKET'):
        fragment.add_source_files( os.path.join(fragment.root_path, "source/cfsocket.cpp") )
        fragment.add_header_files( os.path.join(fragment.root_path, "include/twitchsdk/core/cfsocket.h") )

        if not primitives.implemented('TLS_SOCKET_FACTORY'):
            primitives.set('TLS_SOCKET_FACTORY', "ttv::SecureCFSocketFactory", "twitchsdk/core/cfsocket.h")

    fragment.add_source_group("Source Files/core/darwin", fragment.source_files)
    fragment.add_source_group("Header Files/core/darwin", fragment.header_files)

    # Include paths
    fragment.add_header_search_paths( os.path.join(fragment.root_path, 'include') )

    # Frameworks and libraries to link against
    fragment.add_link_libraries('-framework CFNetwork', transform_to_absolute_path=False)
    fragment.add_link_libraries('-framework CoreFoundation', transform_to_absolute_path=False)
    fragment.add_link_libraries('-lz', transform_to_absolute_path=False)

    return fragment
