/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/core/socket.h"

#include <CFNetwork/CFNetwork.h>
#include <CoreFoundation/CoreFoundation.h>

namespace ttv {
class CFSocket;
class RawCFSocketFactory;
class SecureCFSocketFactory;
}  // namespace ttv

class ttv::CFSocket : public ISocket {
 public:
  CFSocket(const std::string& host, uint32_t port, bool useSsl);
  virtual ~CFSocket() override;

  // ISocket Implementation
  virtual TTV_ErrorCode Connect() override;
  virtual TTV_ErrorCode Disconnect() override;
  virtual TTV_ErrorCode Send(const uint8_t* buffer, size_t length, size_t& sent) override;
  virtual TTV_ErrorCode Recv(uint8_t* buffer, size_t length, size_t& received) override;
  virtual uint64_t TotalSent() override;
  virtual uint64_t TotalReceived() override;
  virtual bool Connected() override;

 private:
  std::string mHostName;
  uint32_t mPort;
  uint64_t mTotalSent;
  uint64_t mTotalReceived;
  bool mUseSsl;
  CFReadStreamRef mReadStream;
  CFWriteStreamRef mWriteStream;
};

class ttv::RawCFSocketFactory : public ttv::ISocketFactory {
 public:
  virtual bool IsProtocolSupported(const std::string& protocol) override;
  virtual TTV_ErrorCode CreateSocket(const std::string& uri, std::shared_ptr<ISocket>& result) override;
};

class ttv::SecureCFSocketFactory : public ttv::ISocketFactory {
 public:
  virtual bool IsProtocolSupported(const std::string& protocol) override;
  virtual TTV_ErrorCode CreateSocket(const std::string& uri, std::shared_ptr<ISocket>& result) override;
};
