package tv.twitch;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum BroadcastPlatform {
    // BINDING_ENUM_START (Do not remove this line, it's used by the bindings tools)
    WatchParty(0),
    Premiere(1),
    Rerun(2),
    Playlist(3),
    Mobile(4),
    Xbox(5),
    PS4(6),
    Live(7),
    Unknown(8);
    // BINDING_ENUM_END (Do not remove this line, it's used by the bindings tools)

    private static Map<Integer, BroadcastPlatform> s_Map = new HashMap<Integer, BroadcastPlatform>();

    static {
        EnumSet<BroadcastPlatform> set = EnumSet.allOf(BroadcastPlatform.class);

        for (BroadcastPlatform e : set) {
            s_Map.put(e.getValue(), e);
        }
    }

    public static BroadcastPlatform lookupValue(int val) {
        BroadcastPlatform err = s_Map.get(val);
        return err;
    }

    private int m_Value;

    private BroadcastPlatform(int value) { this.m_Value = value; }

    public int getValue() { return m_Value; }
}
