package tv.twitch;

public class ChannelStatusProxy extends NativeProxy implements IChannelStatus {
    // AND-9927 It is safe to dispose a ChannelStatusProxy from any thread.
    private native void DisposeNativeInstance(long nativeObjectPointer);

    private native ErrorCode UploadProfileImage(
        long nativeObjectPointer, byte[] imageBuffer, int imageSize, UploadProfileImageCallback callback);

    public ChannelStatusProxy(long nativeObjectPointer, IJniThreadValidator jniThreadValidator) {
        super(nativeObjectPointer, jniThreadValidator);
    }

    @Override
    protected void disposeNativeInstance(long nativeObjectPointer) {
        // AND-9927 It is safe to dispose a ChannelStatusProxy from any thread.
        DisposeNativeInstance(nativeObjectPointer);
    }

    @Override
    public ErrorCode uploadProfileImage(
        final byte[] imageBuffer, final int imageSize, final UploadProfileImageCallback callback) {
        return mJniThreadValidator.callJniCallable(new IJniCallable<ErrorCode>() {
            @Override
            public ErrorCode call() {
                return UploadProfileImage(getNativeObjectPointer(), imageBuffer, imageSize, callback);
            }
        });
    }
}
