package tv.twitch;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum CorePubSubState {
    // BINDING_ENUM_START (Do not remove this line, it's used by the bindings tools)
    TTV_CORE_PUBSUB_STATE_DISCONNECTED(0),
    TTV_CORE_PUBSUB_STATE_CONNECTING(1),
    TTV_CORE_PUBSUB_STATE_CONNECTED(2),
    TTV_CORE_PUBSUB_STATE_DISCONNECTING(3);
    // BINDING_ENUM_END (Do not remove this line, it's used by the bindings tools)

    private static Map<Integer, CorePubSubState> s_Map = new HashMap<Integer, CorePubSubState>();

    static {
        EnumSet<CorePubSubState> set = EnumSet.allOf(CorePubSubState.class);

        for (CorePubSubState e : set) {
            s_Map.put(e.getValue(), e);
        }
    }

    public static CorePubSubState lookupValue(int val) {
        CorePubSubState err = s_Map.get(val);
        return err;
    }

    private int m_Value;

    private CorePubSubState(int value) { this.m_Value = value; }

    public int getValue() { return m_Value; }
}
