package tv.twitch;

public class DashboardActivityStatusProxy extends NativeProxy implements IDashboardActivityStatus {
    // AND-9927 It is safe to dispose a DashboardActivityStatusProxy from any thread.
    private native void DisposeNativeInstance(long nativeObjectPointer);

    public DashboardActivityStatusProxy(long nativeObjectPointer) {
        // AND-9927 It is safe to dispose a DashboardActivityStatusProxy from any thread.
        super(nativeObjectPointer, PassThroughJniThreadValidator.INSTANCE);
    }

    @Override
    protected void disposeNativeInstance(long nativeObjectPointer) {
        // AND-9927 It is safe to dispose a DashboardActivityStatusProxy from any thread.
        DisposeNativeInstance(nativeObjectPointer);
    }
}
