package tv.twitch;

public class EventSchedulerProxy extends NativeProxy implements IEventScheduler {
    private native Result<TaskId> ScheduleTask(long nativeObjectPointer, TaskParams taskParams);
    private native ErrorCode CancelTask(long nativeObjectPointer, TaskId taskId);
    private native ErrorCode Shutdown(long nativeObjectPointer, TaskFunction shutdownCallback);
    private native EventSchedulerState GetState(long nativeObjectPointer);
    // AND-9927 Disposing an EventSchedulerProxy is safe from any thread
    private native void DisposeNativeInstance(long nativeObjectPointer);

    public EventSchedulerProxy(long nativeObjectPointer, IJniThreadValidator jniThreadValidator) {
        super(nativeObjectPointer, jniThreadValidator);
    }

    @Override
    public Result<TaskId> scheduleTask(final TaskParams taskParams) {
        return mJniThreadValidator.callJniCallable(new IJniCallable<Result<TaskId>>() {
            @Override
            public Result<TaskId> call() {
                return ScheduleTask(getNativeObjectPointer(), taskParams);
            }
        });
    }

    @Override
    public ErrorCode cancelTask(final TaskId taskId) {
        return mJniThreadValidator.callJniCallable(new IJniCallable<ErrorCode>() {
            @Override
            public ErrorCode call() {
                return CancelTask(getNativeObjectPointer(), taskId);
            }
        });
    }

    @Override
    public ErrorCode shutdown(final TaskFunction shutdownCallback) {
        return mJniThreadValidator.callJniCallable(new IJniCallable<ErrorCode>() {
            @Override
            public ErrorCode call() {
                return Shutdown(getNativeObjectPointer(), shutdownCallback);
            }
        });
    }

    @Override
    public EventSchedulerState getState() {
        return mJniThreadValidator.callJniCallable(new IJniCallable<EventSchedulerState>() {
            @Override
            public EventSchedulerState call() {
                return GetState(getNativeObjectPointer());
            }
        });
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    protected void disposeNativeInstance(long nativeObjectPointer) {
        // AND-9927 Disposing an EventSchedulerProxy is safe from any thread
        DisposeNativeInstance(nativeObjectPointer);
    }
}
