package tv.twitch;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum EventSchedulerState {
    // BINDING_ENUM_START (Do not remove this line, it's used by the bindings tools)
    Running(0),
    ShuttingDown(1),
    ShutDown(2);
    // BINDING_ENUM_END (Do not remove this line, it's used by the bindings tools)

    private static Map<Integer, EventSchedulerState> s_Map = new HashMap<Integer, EventSchedulerState>();

    static {
        EnumSet<EventSchedulerState> set = EnumSet.allOf(EventSchedulerState.class);

        for (EventSchedulerState e : set) {
            s_Map.put(e.getValue(), e);
        }
    }

    public static EventSchedulerState lookupValue(int val) {
        EventSchedulerState err = s_Map.get(val);
        return err;
    }

    private int m_Value;

    private EventSchedulerState(int value) { this.m_Value = value; }

    public int getValue() { return m_Value; }
}
