package tv.twitch;

public class GenericSubscriberStatusProxy extends NativeProxy implements IGenericSubscriberStatus {
    // AND-9927 It is safe to dispose of an GenericSubscriberStatusProxy from any thread.
    private native void DisposeNativeInstance(long nativeObjectPointer);

    public GenericSubscriberStatusProxy(long nativeObjectPointer) {
        // AND-9927 It is safe to dispose of an GenericSubscriberStatusProxy from any thread.
        super(nativeObjectPointer, PassThroughJniThreadValidator.INSTANCE);
    }

    @Override
    protected void disposeNativeInstance(long nativeObjectPointer) {
        // AND-9927 It is safe to dispose of an GenericSubscriberStatusProxy from any thread.
        DisposeNativeInstance(nativeObjectPointer);
    }
}
