package tv.twitch;

import java.util.HashMap;

/**
 * An interface clients can implement that allows the SDK to send tracking events.
 */
public interface IEventTracker {
    /**
     * Sends a tracking event.
     * @param[in] eventName The name of the event to send.
     * @param[in] properties A map of the event properties to send with the event.
     *     The values in the HashMap can be of the following types:
     *         null
     *         Boolean
     *         Long
     *         Double
     *         String
     */
    ErrorCode trackEvent(String eventName, HashMap<String, Object> properties);
}
