package tv.twitch;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum ModuleState {
    // BINDING_ENUM_START (Do not remove this line, it's used by the bindings tools)
    Uninitialized(0),
    Initializing(1),
    Initialized(2),
    ShuttingDown(3);
    // BINDING_ENUM_END (Do not remove this line, it's used by the bindings tools)

    private static Map<Integer, ModuleState> s_Map = new HashMap<Integer, ModuleState>();

    static {
        EnumSet<ModuleState> set = EnumSet.allOf(ModuleState.class);

        for (ModuleState e : set) {
            s_Map.put(e.getValue(), e);
        }
    }

    public static ModuleState lookupValue(int val) {
        ModuleState err = s_Map.get(val);
        return err;
    }

    private int m_Value;

    private ModuleState(int value) { this.m_Value = value; }

    public int getValue() { return m_Value; }
}
