package tv.twitch;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum SquadStatus {
    Unknown(0),
    Pending(1),
    Live(2),
    Ended(3);

    private static Map<Integer, SquadStatus> s_Map = new HashMap<Integer, SquadStatus>();

    static {
        EnumSet<SquadStatus> set = EnumSet.allOf(SquadStatus.class);

        for (SquadStatus e : set) {
            s_Map.put(e.getValue(), e);
        }
    }

    public static SquadStatus lookupValue(int val) {
        SquadStatus err = s_Map.get(val);
        return err;
    }

    private int m_Value;

    private SquadStatus(int value) { this.m_Value = value; }

    public int getValue() { return m_Value; }
}
