package tv.twitch;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum StreamType {
    // BINDING_ENUM_START (Do not remove this line, it's used by the bindings tools)
    WatchParty(0),
    Premiere(1),
    Rerun(2),
    Playlist(3),
    Live(4),
    Unknown(5);
    // BINDING_ENUM_END (Do not remove this line, it's used by the bindings tools)

    private static Map<Integer, StreamType> s_Map = new HashMap<Integer, StreamType>();

    static {
        EnumSet<StreamType> set = EnumSet.allOf(StreamType.class);

        for (StreamType e : set) {
            s_Map.put(e.getValue(), e);
        }
    }

    public static StreamType lookupValue(int val) {
        StreamType err = s_Map.get(val);
        return err;
    }

    private int m_Value;

    private StreamType(int value) { this.m_Value = value; }

    public int getValue() { return m_Value; }
}
