package tv.twitch;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum VodType {
    // BINDING_ENUM_START (Do not remove this line, it's used by the bindings tools)
    Highlight(0),
    Archive(1),
    Upload(2),
    Unknown(3);
    // BINDING_ENUM_END (Do not remove this line, it's used by the bindings tools)

    private static Map<Integer, VodType> s_Map = new HashMap<Integer, VodType>();

    static {
        EnumSet<VodType> set = EnumSet.allOf(VodType.class);

        for (VodType e : set) {
            s_Map.put(e.getValue(), e);
        }
    }

    public static VodType lookupValue(int val) {
        VodType err = s_Map.get(val);
        return err;
    }

    private int m_Value;

    private VodType(int value) { this.m_Value = value; }

    public int getValue() { return m_Value; }
}
