##########################################################################################################
#
# Fragment: core_java
#
# See README.md for fragment documentation.
#
##########################################################################################################

import glob
import os
import build_types
import build_tools

def load_twitchsdk_fragment(primitives, options):

    fragment = build_types.SourceFragment('twitchsdk', 'core_java', os.path.dirname(os.path.realpath(__file__)))

    # Add source
    build_tools.add_source_files_recursively(fragment, 'source', ['.cpp'], 'Source Files/core/java')
    build_tools.add_source_files_recursively(fragment, 'tests/unit/source', ['.cpp'], 'Source Files/core/java/test')

    # Add headers
    build_tools.add_source_files_recursively(fragment, 'include/twitchsdk/core', ['.h'], 'Header Files/core/java')
    build_tools.add_source_files_recursively(fragment, 'tests/unit/include/twitchsdk/core', ['.h'], 'Header Files/core/java/test')

    # Include paths
    fragment.add_header_search_paths( os.path.join(fragment.root_path, 'include') )

    # Find the JDK
    jdk_dir = None
    if options.has_setting('TTV_JDK_PATH'):
        jdk_dir = options.settings['TTV_JDK_PATH']
    elif 'TTV_JDK_PATH' in os.environ:
        jdk_dir = os.environ['TTV_JDK_PATH']
    elif 'JAVA_HOME' in os.environ:
        jdk_dir = os.environ['JAVA_HOME']
    else:
        raise Exception("TTV_JDK_PATH was not passed in on command line and JAVA_HOME or TTV_JDK_PATH is not set as an environment variable.")

    # Add JNI to the header search paths. Android has their own jni.h, so don't use JDK's.
    if options.primary_platform != 'android':
        fragment.add_header_search_paths( os.path.join(jdk_dir, 'include', options.primary_platform) )
        fragment.add_header_search_paths( os.path.join(jdk_dir, 'include') )
    fragment.add_header_search_paths( os.path.join(fragment.root_path, 'tests', 'unit', 'include') )

    # Export symbols
    fragment.add_symbol_export_files( os.path.join(fragment.root_path, 'source', 'exports.txt') )

    return fragment
