/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/core/channel/ichannellistener.h"
#include "twitchsdk/core/java_nativelistener.h"

namespace ttv {
namespace binding {
namespace java {
class JavaChannelListenerProxy;
}
}  // namespace binding
}  // namespace ttv

class ttv::binding::java::JavaChannelListenerProxy : public NativeListenerProxy<IChannelListener> {
 public:
  JavaChannelListenerProxy();

  virtual void StreamUp(uint32_t playDelaySeconds) override;
  virtual void StreamDown() override;
  virtual void StreamViewerCountChanged(uint32_t viewerCount) override;
  virtual void StreamTriggeredMidroll(uint32_t durationSeconds) override;
  virtual void StreamReceivedWatchPartyUpdate(const WatchPartyUpdate& update) override;
  virtual void ProfileImageUpdated(const std::vector<ProfileImage>& images) override;
  virtual void StreamInfoUpdated(StreamInfoUpdate&& info) override;
  virtual void SquadUpdated(SquadInfo&& squad) override;
  virtual void SquadLeft() override;
  virtual void PixelTrackingUpdate(bool refresh) override;
};
