/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/core/corelistener.h"
#include "twitchsdk/core/generated/java_all.h"
#include "twitchsdk/core/generated/jni_all.h"
#include "twitchsdk/core/java_nativelistener.h"

namespace ttv {
namespace binding {
namespace java {
class JavaCoreAPIListenerProxy;
}
}  // namespace binding
}  // namespace ttv

class ttv::binding::java::JavaCoreAPIListenerProxy : public NativeModuleListener<ICoreAPIListener> {
 public:
  JavaCoreAPIListenerProxy(jobject jModule);

 public:
  virtual void CoreUserLoginComplete(
    const std::string& oauthToken, UserId userId, const ErrorDetails& errorDetails) override;
  virtual void CoreUserLogoutComplete(UserId userId, TTV_ErrorCode ec) override;
  virtual void CoreUserAuthenticationIssue(
    UserId userId, const std::string& oauthToken, const ErrorDetails& errorDetails) override;
  virtual void CorePubSubStateChanged(UserId userId, PubSubState state, TTV_ErrorCode ec) override;
};
