/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/core/java_utility.h"
#include "twitchsdk/core/module.h"
#include "twitchsdk/core/socket.h"

#include <unordered_map>

namespace ttv {
class CoreAPI;
class IChannelStatus;
class IDashboardActivityStatus;
class IGenericSubscriberStatus;

namespace binding {
namespace java {
class JavaCoreAPIListenerProxy;

struct CoreApiContext {
  std::shared_ptr<ttv::CoreAPI> coreApi;
  std::shared_ptr<JavaCoreAPIListenerProxy> nativeListener;
};

extern JavaNativeProxyRegistry<ttv::CoreAPI, CoreApiContext> gCoreApiNativeProxyRegistry;
extern JavaNativeProxyRegistry<ttv::IChannelStatus, CoreApiContext> gIChannelStatusInstanceRegistry;
extern JavaNativeProxyRegistry<ttv::IDashboardActivityStatus, CoreApiContext> gIDashboardActivityStatusInstanceRegistry;
extern JavaNativeProxyRegistry<ttv::IGenericSubscriberStatus, CoreApiContext> gIGenericSubscriberStatusInstanceRegistry;

/**
 * Loads all Java class information for the core module.
 */
void LoadAllCoreJavaClassInfo(JNIEnv* jEnv);

jobject GetJavaInstance_PubSubState(JNIEnv* jEnv, ttv::PubSubState state);
jobject GetJavaInstance_UserInfo(JNIEnv* jEnv, const ttv::UserInfo& userInfo);
jobject GetJavaInstance_UserInfoArray(JNIEnv* jEnv, const std::vector<ttv::UserInfo>& userInfoList);
jobject GetJavaInstance_StreamInfo(JNIEnv* jEnv, const ttv::StreamInfo& streamInfo);
jobject GetJavaInstance_StreamInfoUpdate(JNIEnv* jEnv, const ttv::StreamInfoUpdate& streamInfoUpdate);
jobject GetJavaInstance_CanTheyError(JNIEnv* jEnv, const ttv::CanTheyError& canTheyError);
jobject GetJavaInstance_ChannelInfo(JNIEnv* jEnv, const ttv::ChannelInfo& channelInfo);
jobject GetJavaInstance_WatchPartyUpdate(JNIEnv* jEnv, const ttv::WatchPartyUpdate& update);
jobject GetJavaInstance_ProfileImage(JNIEnv* jEnv, const ttv::ProfileImage& image);
jobject GetJavaInstance_ProfileImageArray(JNIEnv* jEnv, const std::vector<ttv::ProfileImage>& images);
jobject GetJavaInstance_TrackingValue(JNIEnv* jEnv, const TrackingValue& value);
jobject GetJavaInstance_PreviewImages(JNIEnv* jEnv, const PreviewImages& previewImages);
jobject GetJavaInstance_SquadMember(JNIEnv* jEnv, const SquadMember& member);
jobject GetJavaInstance_SquadInfo(JNIEnv* jEnv, const SquadInfo& info);
jobject GetJavaInstance_DashboardActivityHeader(JNIEnv* jEnv, const DashboardActivityHeader& data);
jobject GetJavaInstance_DashboardActivityUser(JNIEnv* jEnv, const DashboardActivityUser& data);
jobject GetJavaInstance_DashboardActivityFragment(JNIEnv* jEnv, const DashboardActivityFragment& data);
jobject GetJavaInstance_DashboardActivityBitsUsage(JNIEnv* jEnv, const DashboardActivityBitsUsage& data);
jobject GetJavaInstance_DashboardActivityFollow(JNIEnv* jEnv, const DashboardActivityFollow& data);
jobject GetJavaInstance_DashboardActivityHost(JNIEnv* jEnv, const DashboardActivityHost& data);
jobject GetJavaInstance_DashboardActivityRaiding(JNIEnv* jEnv, const DashboardActivityRaiding& data);
jobject GetJavaInstance_DashboardActivitySubscription(JNIEnv* jEnv, const DashboardActivitySubscription& data);
jobject GetJavaInstance_DashboardActivityResubscriptionSharing(
  JNIEnv* jEnv, const DashboardActivityResubscriptionSharing& data);
jobject GetJavaInstance_DashboardActivitySubscriptionGiftingCommunity(
  JNIEnv* jEnv, const DashboardActivitySubscriptionGiftingCommunity& data);
jobject GetJavaInstance_DashboardActivitySubscriptionGiftingIndividual(
  JNIEnv* jEnv, const DashboardActivitySubscriptionGiftingIndividual& data);

std::shared_ptr<ttv::CoreAPI> GetCoreApiInstance(jobject jCoreApi);
}  // namespace java
}  // namespace binding
}  // namespace ttv
