/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/core/idashboardactivitylistener.h"
#include "twitchsdk/core/java_nativelistener.h"

namespace ttv {
namespace binding {
namespace java {
class JavaDashboardActivityListenerProxy;
}
}  // namespace binding
}  // namespace ttv

class ttv::binding::java::JavaDashboardActivityListenerProxy : public NativeListenerProxy<IDashboardActivityListener> {
 public:
  JavaDashboardActivityListenerProxy();

  void EventBitsUseage(const DashboardActivityBitsUsage& data) override;
  void EventFollower(const DashboardActivityFollow& data) override;
  void EventAutoHostStart(const DashboardActivityHost& data) override;
  void EventHostStart(const DashboardActivityHost& data) override;
  void EventRaiding(const DashboardActivityRaiding& data) override;
  void EventSubscription(const DashboardActivitySubscription& data) override;
  void EventPrimeSubscription(const DashboardActivitySubscription& data) override;
  void EventResubscriptionSharing(const DashboardActivityResubscriptionSharing& data) override;
  void EventPrimeResubscriptionSharing(const DashboardActivityResubscriptionSharing& data) override;
  void EventSubscriptionGiftingCommunity(const DashboardActivitySubscriptionGiftingCommunity& data) override;
  void EventSubscriptionGiftingIndividual(const DashboardActivitySubscriptionGiftingIndividual& data) override;
  void EventStreamUp(const DashboardActivityHeader& data) override;
};
