/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/core/generated/java_all.h"
#include "twitchsdk/core/generated/jni_all.h"
#include "twitchsdk/core/java_utility.h"
#include "twitchsdk/core/module.h"
#include "twitchsdk/core/types/errortypes.h"

namespace ttv {
namespace binding {
namespace java {
template <typename LISTENER_TYPE>
class NativeListenerProxy;

template <typename LISTENER_TYPE>
class NativeModuleListener;
}  // namespace java
}  // namespace binding
}  // namespace ttv

template <typename LISTENER_TYPE>
class ttv::binding::java::NativeListenerProxy : public LISTENER_TYPE {
 public:
  virtual ~NativeListenerProxy() {}

  void SetListener(jobject jListener) {
    AutoJEnv jEnv;

    if (mJavaListener.GetInstance() != nullptr) {
      if (jEnv->IsSameObject(mJavaListener.GetInstance(), jListener)) {
        return;
      }
    }

    mJavaListener.Release();

    if (jListener != nullptr) {
      mJavaListener.Bind(jEnv, jListener);
    }

    return;
  }

  jobject GetListener() const { return mJavaListener.GetInstance(); }

 protected:
  GlobalJavaObjectReference mJavaListener;
  JavaClassInfo mListenerInfo;
};

template <typename LISTENER_TYPE>
class ttv::binding::java::NativeModuleListener : public NativeListenerProxy<LISTENER_TYPE> {
 public:
  NativeModuleListener(jobject jModule) {
    mJavaModule.Bind(gActiveJavaEnvironment, jModule);

    mModuleListenerInfo = GetJavaClassInfo_IModuleListener(gActiveJavaEnvironment);
  }

  virtual void ModuleStateChanged(ttv::IModule* /*source*/, ttv::IModule::State state, TTV_ErrorCode ec) override {
    jobject jListener = NativeListenerProxy<LISTENER_TYPE>::mJavaListener.GetInstance();
    if (jListener == nullptr) {
      return;
    }

    // Notify the java client
    AUTO_DELETE_LOCAL_REF(gActiveJavaEnvironment, jobject, jState,
      GetJavaInstance_SimpleEnum(gActiveJavaEnvironment, GetJavaClassInfo_ModuleState(gActiveJavaEnvironment), state));
    AUTO_DELETE_LOCAL_REF(
      gActiveJavaEnvironment, jobject, jResult, GetJavaInstance_ErrorCode(gActiveJavaEnvironment, ec));

    gActiveJavaEnvironment->CallVoidMethod(
      jListener, mModuleListenerInfo.methods["moduleStateChanged"], mJavaModule.GetInstance(), jState, jResult);
  }

 protected:
  GlobalJavaObjectReference mJavaModule;
  JavaClassInfo mModuleListenerInfo;
};
