/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2017 Twitch Interactive, Inc.
*********************************************************************************************/

#include "twitchsdk/core/internal/pch.h"
#include "twitchsdk/core/generated/java_broadcastplatform.h"

::ttv::binding::java::JavaClassInfo& ttv::binding::java::GetJavaClassInfo_BroadcastPlatform(JNIEnv* jEnv)
{
    static ::ttv::binding::java::JavaClassInfo info;
    static bool initialized = false;

    if (!initialized)
    {
        initialized = true;

        LookupJavaClass(jEnv, info, "tv/twitch/BroadcastPlatform");

        LookupJavaStaticMethod(jEnv, info, "lookupValue", "(I)Ltv/twitch/BroadcastPlatform;"); // public static tv.twitch.BroadcastPlatform lookupValue(int);
        LookupJavaStaticMethod(jEnv, info, "values", "()[Ltv/twitch/BroadcastPlatform;"); // public static tv.twitch.BroadcastPlatform[] values();
        LookupJavaStaticMethod(jEnv, info, "valueOf", "(Ljava/lang/String;)Ltv/twitch/BroadcastPlatform;"); // public static tv.twitch.BroadcastPlatform valueOf(java.lang.String);

        LookupJavaMethod(jEnv, info, "getValue", "()I"); // public int getValue();

    }

    return info;
}
