/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2017 Twitch Interactive, Inc.
*********************************************************************************************/

#include "twitchsdk/core/internal/pch.h"
#include "twitchsdk/core/generated/java_cantheyerror.h"

::ttv::binding::java::JavaClassInfo& ttv::binding::java::GetJavaClassInfo_CanTheyError(JNIEnv* jEnv)
{
    static ::ttv::binding::java::JavaClassInfo info;
    static bool initialized = false;

    if (!initialized)
    {
        initialized = true;

        LookupJavaClass(jEnv, info, "tv/twitch/CanTheyError");

        LookupJavaMethod(jEnv, info, "<init>", "()V"); // public tv.twitch.CanTheyError();

        LookupJavaField(jEnv, info, "code", "Ljava/lang/String;"); // public java.lang.String code;
        LookupJavaField(jEnv, info, "message", "Ljava/lang/String;"); // public java.lang.String message;
        LookupJavaField(jEnv, info, "links", "[Ljava/lang/String;"); // public java.lang.String[] links;
    }

    return info;
}
