/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2017 Twitch Interactive, Inc.
*********************************************************************************************/

#include "twitchsdk/core/internal/pch.h"
#include "twitchsdk/core/generated/java_channelinfo.h"

::ttv::binding::java::JavaClassInfo& ttv::binding::java::GetJavaClassInfo_ChannelInfo(JNIEnv* jEnv)
{
    static ::ttv::binding::java::JavaClassInfo info;
    static bool initialized = false;

    if (!initialized)
    {
        initialized = true;

        LookupJavaClass(jEnv, info, "tv/twitch/ChannelInfo");

        LookupJavaMethod(jEnv, info, "<init>", "()V"); // public tv.twitch.ChannelInfo();

        LookupJavaField(jEnv, info, "displayName", "Ljava/lang/String;"); // public java.lang.String displayName;
        LookupJavaField(jEnv, info, "name", "Ljava/lang/String;"); // public java.lang.String name;
        LookupJavaField(jEnv, info, "game", "Ljava/lang/String;"); // public java.lang.String game;
        LookupJavaField(jEnv, info, "description", "Ljava/lang/String;"); // public java.lang.String description;
        LookupJavaField(jEnv, info, "status", "Ljava/lang/String;"); // public java.lang.String status;
        LookupJavaField(jEnv, info, "language", "Ljava/lang/String;"); // public java.lang.String language;
        LookupJavaField(jEnv, info, "broadcasterLanguage", "Ljava/lang/String;"); // public java.lang.String broadcasterLanguage;
        LookupJavaField(jEnv, info, "logoImageUrl", "Ljava/lang/String;"); // public java.lang.String logoImageUrl;
        LookupJavaField(jEnv, info, "channelUrl", "Ljava/lang/String;"); // public java.lang.String channelUrl;
        LookupJavaField(jEnv, info, "videoBannerImageUrl", "Ljava/lang/String;"); // public java.lang.String videoBannerImageUrl;
        LookupJavaField(jEnv, info, "profileBannerImageUrl", "Ljava/lang/String;"); // public java.lang.String profileBannerImageUrl;
        LookupJavaField(jEnv, info, "channelId", "I"); // public int channelId;
        LookupJavaField(jEnv, info, "createdAtTimestamp", "I"); // public int createdAtTimestamp;
        LookupJavaField(jEnv, info, "updatedAtTimestamp", "I"); // public int updatedAtTimestamp;
        LookupJavaField(jEnv, info, "numFollowers", "I"); // public int numFollowers;
        LookupJavaField(jEnv, info, "numViews", "I"); // public int numViews;
        LookupJavaField(jEnv, info, "mature", "Z"); // public boolean mature;
        LookupJavaField(jEnv, info, "partner", "Z"); // public boolean partner;
        LookupJavaField(jEnv, info, "affiliate", "Z"); // public boolean affiliate;
    }

    return info;
}
