/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2017 Twitch Interactive, Inc.
*********************************************************************************************/

#include "twitchsdk/core/internal/pch.h"
#include "twitchsdk/core/generated/java_channelstatusproxy.h"

::ttv::binding::java::JavaClassInfo& ttv::binding::java::GetJavaClassInfo_ChannelStatusProxy(JNIEnv* jEnv)
{
    static ::ttv::binding::java::JavaClassInfo info;
    static bool initialized = false;

    if (!initialized)
    {
        initialized = true;

        LookupJavaClass(jEnv, info, "tv/twitch/ChannelStatusProxy");

        LookupJavaMethod(jEnv, info, "<init>", "(JLtv/twitch/IJniThreadValidator;)V"); // public tv.twitch.ChannelStatusProxy(long, tv.twitch.IJniThreadValidator);

        LookupJavaMethod(jEnv, info, "disposeNativeInstance", "(J)V"); // protected void disposeNativeInstance(long);
        LookupJavaMethod(jEnv, info, "uploadProfileImage", "([BILtv/twitch/IChannelStatus$UploadProfileImageCallback;)Ltv/twitch/ErrorCode;"); // public tv.twitch.ErrorCode uploadProfileImage(byte[], int, tv.twitch.IChannelStatus$UploadProfileImageCallback);
    }

    return info;
}
