/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2017 Twitch Interactive, Inc.
*********************************************************************************************/

#include "twitchsdk/core/internal/pch.h"
#include "twitchsdk/core/generated/java_coreapi_logincallback.h"

::ttv::binding::java::JavaClassInfo& ttv::binding::java::GetJavaClassInfo_CoreAPI_LogInCallback(JNIEnv* jEnv)
{
    static ::ttv::binding::java::JavaClassInfo info;
    static bool initialized = false;

    if (!initialized)
    {
        initialized = true;

        LookupJavaClass(jEnv, info, "tv/twitch/CoreAPI$LogInCallback");

        LookupJavaMethod(jEnv, info, "invoke", "(Ltv/twitch/ErrorCode;Ltv/twitch/UserInfo;)V"); // public abstract void invoke(tv.twitch.ErrorCode, tv.twitch.UserInfo);
    }

    return info;
}
