/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2017 Twitch Interactive, Inc.
*********************************************************************************************/

#include "twitchsdk/core/internal/pch.h"
#include "twitchsdk/core/generated/java_dashboardactivityhost.h"

::ttv::binding::java::JavaClassInfo& ttv::binding::java::GetJavaClassInfo_DashboardActivityHost(JNIEnv* jEnv)
{
    static ::ttv::binding::java::JavaClassInfo info;
    static bool initialized = false;

    if (!initialized)
    {
        initialized = true;

        LookupJavaClass(jEnv, info, "tv/twitch/DashboardActivityHost");

        LookupJavaMethod(jEnv, info, "<init>", "()V"); // public tv.twitch.DashboardActivityHost();

        LookupJavaField(jEnv, info, "header", "Ltv/twitch/DashboardActivityHeader;"); // public tv.twitch.DashboardActivityHeader header;
        LookupJavaField(jEnv, info, "host", "Ltv/twitch/DashboardActivityUser;"); // public tv.twitch.DashboardActivityUser host;
        LookupJavaField(jEnv, info, "viewerCount", "I"); // public int viewerCount;
    }

    return info;
}
