/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2017 Twitch Interactive, Inc.
*********************************************************************************************/

#include "twitchsdk/core/internal/pch.h"
#include "twitchsdk/core/generated/java_dashboardactivityraiding.h"

::ttv::binding::java::JavaClassInfo& ttv::binding::java::GetJavaClassInfo_DashboardActivityRaiding(JNIEnv* jEnv)
{
    static ::ttv::binding::java::JavaClassInfo info;
    static bool initialized = false;

    if (!initialized)
    {
        initialized = true;

        LookupJavaClass(jEnv, info, "tv/twitch/DashboardActivityRaiding");

        LookupJavaMethod(jEnv, info, "<init>", "()V"); // public tv.twitch.DashboardActivityRaiding();

        LookupJavaField(jEnv, info, "header", "Ltv/twitch/DashboardActivityHeader;"); // public tv.twitch.DashboardActivityHeader header;
        LookupJavaField(jEnv, info, "raider", "Ltv/twitch/DashboardActivityUser;"); // public tv.twitch.DashboardActivityUser raider;
        LookupJavaField(jEnv, info, "viewerCount", "I"); // public int viewerCount;
    }

    return info;
}
