/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2017 Twitch Interactive, Inc.
*********************************************************************************************/

#include "twitchsdk/core/internal/pch.h"
#include "twitchsdk/core/generated/java_dashboardactivityresubscriptionsharing.h"

::ttv::binding::java::JavaClassInfo& ttv::binding::java::GetJavaClassInfo_DashboardActivityResubscriptionSharing(JNIEnv* jEnv)
{
    static ::ttv::binding::java::JavaClassInfo info;
    static bool initialized = false;

    if (!initialized)
    {
        initialized = true;

        LookupJavaClass(jEnv, info, "tv/twitch/DashboardActivityResubscriptionSharing");

        LookupJavaMethod(jEnv, info, "<init>", "()V"); // public tv.twitch.DashboardActivityResubscriptionSharing();

        LookupJavaField(jEnv, info, "header", "Ltv/twitch/DashboardActivityHeader;"); // public tv.twitch.DashboardActivityHeader header;
        LookupJavaField(jEnv, info, "subscriber", "Ltv/twitch/DashboardActivityUser;"); // public tv.twitch.DashboardActivityUser subscriber;
        LookupJavaField(jEnv, info, "tier", "Ljava/lang/String;"); // public java.lang.String tier;
        LookupJavaField(jEnv, info, "cumulativeTenureMonths", "I"); // public int cumulativeTenureMonths;
        LookupJavaField(jEnv, info, "customMessageFragments", "[Ltv/twitch/DashboardActivityFragment;"); // public tv.twitch.DashboardActivityFragment[] customMessageFragments;
        LookupJavaField(jEnv, info, "customMessage", "Ljava/lang/String;"); // public java.lang.String customMessage;
    }

    return info;
}
