/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2017 Twitch Interactive, Inc.
*********************************************************************************************/

#include "twitchsdk/core/internal/pch.h"
#include "twitchsdk/core/generated/java_dashboardactivityuser.h"

::ttv::binding::java::JavaClassInfo& ttv::binding::java::GetJavaClassInfo_DashboardActivityUser(JNIEnv* jEnv)
{
    static ::ttv::binding::java::JavaClassInfo info;
    static bool initialized = false;

    if (!initialized)
    {
        initialized = true;

        LookupJavaClass(jEnv, info, "tv/twitch/DashboardActivityUser");

        LookupJavaMethod(jEnv, info, "<init>", "()V"); // public tv.twitch.DashboardActivityUser();

        LookupJavaField(jEnv, info, "displayName", "Ljava/lang/String;"); // public java.lang.String displayName;
        LookupJavaField(jEnv, info, "login", "Ljava/lang/String;"); // public java.lang.String login;
        LookupJavaField(jEnv, info, "userId", "Ljava/lang/String;"); // public java.lang.String userId;
    }

    return info;
}
