/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2017 Twitch Interactive, Inc.
*********************************************************************************************/

#include "twitchsdk/core/internal/pch.h"
#include "twitchsdk/core/generated/java_ichannellistener.h"

::ttv::binding::java::JavaClassInfo& ttv::binding::java::GetJavaClassInfo_IChannelListener(JNIEnv* jEnv)
{
    static ::ttv::binding::java::JavaClassInfo info;
    static bool initialized = false;

    if (!initialized)
    {
        initialized = true;

        LookupJavaClass(jEnv, info, "tv/twitch/IChannelListener");

        LookupJavaMethod(jEnv, info, "streamUp", "(I)V"); // public abstract void streamUp(int);
        LookupJavaMethod(jEnv, info, "streamDown", "()V"); // public abstract void streamDown();
        LookupJavaMethod(jEnv, info, "streamViewerCountChanged", "(I)V"); // public abstract void streamViewerCountChanged(int);
        LookupJavaMethod(jEnv, info, "streamTriggeredMidroll", "(I)V"); // public abstract void streamTriggeredMidroll(int);
        LookupJavaMethod(jEnv, info, "streamReceivedWatchPartyUpdate", "(Ltv/twitch/WatchPartyUpdate;)V"); // public abstract void streamReceivedWatchPartyUpdate(tv.twitch.WatchPartyUpdate);
        LookupJavaMethod(jEnv, info, "profileImageUpdated", "([Ltv/twitch/ProfileImage;)V"); // public abstract void profileImageUpdated(tv.twitch.ProfileImage[]);
        LookupJavaMethod(jEnv, info, "streamInfoUpdated", "(Ltv/twitch/StreamInfoUpdate;)V"); // public abstract void streamInfoUpdated(tv.twitch.StreamInfoUpdate);
        LookupJavaMethod(jEnv, info, "squadUpdated", "(Ltv/twitch/SquadInfo;)V"); // public abstract void squadUpdated(tv.twitch.SquadInfo);
        LookupJavaMethod(jEnv, info, "squadLeft", "()V"); // public abstract void squadLeft();
        LookupJavaMethod(jEnv, info, "pixelTrackingUpdate", "(Ljava/lang/Boolean;)V"); // public abstract void pixelTrackingUpdate(java.lang.Boolean);
    }

    return info;
}
