/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2017 Twitch Interactive, Inc.
*********************************************************************************************/

#include "twitchsdk/core/internal/pch.h"
#include "twitchsdk/core/generated/java_icoreapilistener.h"

::ttv::binding::java::JavaClassInfo& ttv::binding::java::GetJavaClassInfo_ICoreAPIListener(JNIEnv* jEnv)
{
    static ::ttv::binding::java::JavaClassInfo info;
    static bool initialized = false;

    if (!initialized)
    {
        initialized = true;

        LookupJavaClass(jEnv, info, "tv/twitch/ICoreAPIListener");

        LookupJavaMethod(jEnv, info, "coreUserLoginComplete", "(Ljava/lang/String;ILtv/twitch/ErrorCode;)V"); // public abstract void coreUserLoginComplete(java.lang.String, int, tv.twitch.ErrorCode);
        LookupJavaMethod(jEnv, info, "coreUserLogoutComplete", "(ILtv/twitch/ErrorCode;)V"); // public abstract void coreUserLogoutComplete(int, tv.twitch.ErrorCode);
        LookupJavaMethod(jEnv, info, "coreUserAuthenticationIssue", "(ILjava/lang/String;Ltv/twitch/ErrorCode;)V"); // public abstract void coreUserAuthenticationIssue(int, java.lang.String, tv.twitch.ErrorCode);
        LookupJavaMethod(jEnv, info, "corePubSubStateChanged", "(ILtv/twitch/CorePubSubState;Ltv/twitch/ErrorCode;)V"); // public abstract void corePubSubStateChanged(int, tv.twitch.CorePubSubState, tv.twitch.ErrorCode);
    }

    return info;
}
