/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2017 Twitch Interactive, Inc.
*********************************************************************************************/

#include "twitchsdk/core/internal/pch.h"
#include "twitchsdk/core/generated/java_idashboardactivitylistener.h"

::ttv::binding::java::JavaClassInfo& ttv::binding::java::GetJavaClassInfo_IDashboardActivityListener(JNIEnv* jEnv)
{
    static ::ttv::binding::java::JavaClassInfo info;
    static bool initialized = false;

    if (!initialized)
    {
        initialized = true;

        LookupJavaClass(jEnv, info, "tv/twitch/IDashboardActivityListener");

        LookupJavaMethod(jEnv, info, "eventBitsUseage", "(Ltv/twitch/DashboardActivityBitsUsage;)V"); // public abstract void eventBitsUseage(tv.twitch.DashboardActivityBitsUsage);
        LookupJavaMethod(jEnv, info, "eventFollower", "(Ltv/twitch/DashboardActivityFollow;)V"); // public abstract void eventFollower(tv.twitch.DashboardActivityFollow);
        LookupJavaMethod(jEnv, info, "eventAutoHostStart", "(Ltv/twitch/DashboardActivityHost;)V"); // public abstract void eventAutoHostStart(tv.twitch.DashboardActivityHost);
        LookupJavaMethod(jEnv, info, "eventHostStart", "(Ltv/twitch/DashboardActivityHost;)V"); // public abstract void eventHostStart(tv.twitch.DashboardActivityHost);
        LookupJavaMethod(jEnv, info, "eventRaiding", "(Ltv/twitch/DashboardActivityRaiding;)V"); // public abstract void eventRaiding(tv.twitch.DashboardActivityRaiding);
        LookupJavaMethod(jEnv, info, "eventSubscription", "(Ltv/twitch/DashboardActivitySubscription;)V"); // public abstract void eventSubscription(tv.twitch.DashboardActivitySubscription);
        LookupJavaMethod(jEnv, info, "eventPrimeSubscription", "(Ltv/twitch/DashboardActivitySubscription;)V"); // public abstract void eventPrimeSubscription(tv.twitch.DashboardActivitySubscription);
        LookupJavaMethod(jEnv, info, "eventResubscriptionSharing", "(Ltv/twitch/DashboardActivityResubscriptionSharing;)V"); // public abstract void eventResubscriptionSharing(tv.twitch.DashboardActivityResubscriptionSharing);
        LookupJavaMethod(jEnv, info, "eventPrimeResubscriptionSharing", "(Ltv/twitch/DashboardActivityResubscriptionSharing;)V"); // public abstract void eventPrimeResubscriptionSharing(tv.twitch.DashboardActivityResubscriptionSharing);
        LookupJavaMethod(jEnv, info, "eventSubscriptionGiftingCommunity", "(Ltv/twitch/DashboardActivitySubscriptionGiftingCommunity;)V"); // public abstract void eventSubscriptionGiftingCommunity(tv.twitch.DashboardActivitySubscriptionGiftingCommunity);
        LookupJavaMethod(jEnv, info, "eventSubscriptionGiftingIndividual", "(Ltv/twitch/DashboardActivitySubscriptionGiftingIndividual;)V"); // public abstract void eventSubscriptionGiftingIndividual(tv.twitch.DashboardActivitySubscriptionGiftingIndividual);
        LookupJavaMethod(jEnv, info, "eventStreamUp", "(Ltv/twitch/DashboardActivityHeader;)V"); // public abstract void eventStreamUp(tv.twitch.DashboardActivityHeader);
    }

    return info;
}
