/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2017 Twitch Interactive, Inc.
*********************************************************************************************/

#include "twitchsdk/core/internal/pch.h"
#include "twitchsdk/core/generated/java_ieventscheduler.h"

::ttv::binding::java::JavaClassInfo& ttv::binding::java::GetJavaClassInfo_IEventScheduler(JNIEnv* jEnv)
{
    static ::ttv::binding::java::JavaClassInfo info;
    static bool initialized = false;

    if (!initialized)
    {
        initialized = true;

        LookupJavaClass(jEnv, info, "tv/twitch/IEventScheduler");

        LookupJavaMethod(jEnv, info, "scheduleTask", "(Ltv/twitch/TaskParams;)Ltv/twitch/Result;"); // public abstract tv.twitch.Result<tv.twitch.TaskId> scheduleTask(tv.twitch.TaskParams);
        LookupJavaMethod(jEnv, info, "cancelTask", "(Ltv/twitch/TaskId;)Ltv/twitch/ErrorCode;"); // public abstract tv.twitch.ErrorCode cancelTask(tv.twitch.TaskId);
        LookupJavaMethod(jEnv, info, "shutdown", "(Ltv/twitch/TaskFunction;)Ltv/twitch/ErrorCode;"); // public abstract tv.twitch.ErrorCode shutdown(tv.twitch.TaskFunction);
        LookupJavaMethod(jEnv, info, "getState", "()Ltv/twitch/EventSchedulerState;"); // public abstract tv.twitch.EventSchedulerState getState();
        LookupJavaMethod(jEnv, info, "dispose", "()V"); // public abstract void dispose();
    }

    return info;
}
